/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.text_editor;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;

public record Caret(int lineIndex, int gapIndex) {
    public int compareTo(Caret other) {
        if (this.lineIndex != other.lineIndex) {
            return Integer.compare(this.lineIndex, other.lineIndex);
        }
        return Integer.compare(this.gapIndex, other.gapIndex);
    }

    public Caret moveLeftOneCharacter(Int2IntFunction lineLengths) {
        if (this.lineIndex() == 0 && this.gapIndex() == 0) {
            return this;
        }
        if (this.gapIndex() == 0) {
            int newLineIndex = this.lineIndex() - 1;
            int newGapIndex = lineLengths.get(newLineIndex);
            return new Caret(newLineIndex, newGapIndex);
        }
        int newGapIndex = this.gapIndex() - 1;
        return new Caret(this.lineIndex(), newGapIndex);
    }

    public Caret moveRightOneCharacter(Int2IntFunction lineLengths, int numLines) {
        if (this.lineIndex() >= numLines - 1 && this.gapIndex() >= lineLengths.get(this.lineIndex())) {
            return this;
        }
        if (this.gapIndex() >= lineLengths.get(this.lineIndex())) {
            int newLineIndex = this.lineIndex() + 1;
            int newGapIndex = 0;
            return new Caret(newLineIndex, newGapIndex);
        }
        int newGapIndex = this.gapIndex() + 1;
        return new Caret(this.lineIndex(), newGapIndex);
    }

    public Caret moveDownOneLine(Int2IntFunction lineLengths, int numLines) {
        if (this.lineIndex() >= numLines - 1) {
            return this;
        }
        int newLineIndex = this.lineIndex() + 1;
        int newGapIndex = Math.min(this.gapIndex(), lineLengths.get(newLineIndex));
        return new Caret(newLineIndex, newGapIndex);
    }

    public Caret moveUpOneLine(Int2IntFunction lineLengths) {
        if (this.lineIndex() == 0) {
            return this;
        }
        int newLineIndex = this.lineIndex() - 1;
        int newGapIndex = Math.min(this.gapIndex(), lineLengths.get(newLineIndex));
        return new Caret(newLineIndex, newGapIndex);
    }
}

